package java.game.cars;

import java.game.*;
import java.util.*;
import java.game.parts.*;
import java.game.parts.enginepart.airfueldeliverysystem.*;

public class Badge_chassis extends Badge_models
{
	public Badge_chassis( int id )
	{
		super( id );
		carCategory = PACKAGE;

		vehicleName = vendorName = "Badge";
		name = getName();
		
		rID_blueprint = cars.cat_03.Badge:0x018Ar;
		defColorIndex = GameLogic.CARCOLOR_BLACK;
		
		ai_override = "4.0 0.15";
		
		game_version = 2.31;
		ban_mufflers = own_suspension = allow_missing_seats = 1;
		
		value = 11219;
 
		fully_stripped_drag = 0.55;
		min_drag = 0.366;
		drag_reduction_mul = 0.65;
		
		parts_shop_sml = new int[2];
		parts_shop_sml[0] = cars.cat_03.Badge:0x01E3r; //Left taillight dark
		parts_shop_sml[1] = cars.cat_03.Badge:0x01DDr; //Right taillight dark
		
		parts_shop_big = new int[2];
		parts_shop_big[0] = cars.cat_03.Badge:0x00FBr; //Left exhaust
		parts_shop_big[1] = cars.cat_03.Badge:0x00FAr; //Right exhaust
	}

	public void addStockParts( Descriptor desc )
	{
		int actcolor = desc.color;
		float optical = desc.optical;
		float power = desc.power;
		
		super.addStockParts( actcolor, optical, power );

		float part_random;

		randomize( optical + power );

		// parts that have only one appearance //
		if ( optical >= 1.0 )
		{
			addPart( cars.cat_03.badge:0x000000D2r, "trunk", actcolor, optical, power );
			addPart( cars.cat_03.badge:0x000000D3r, "R windshield", actcolor, optical, power );
			addPart( cars.cat_03.badge:0x000000D9r, "FL door", actcolor, optical, power );
			addPart( cars.cat_03.badge:0x000000DAr, "FR door", actcolor, optical, power );
			addPart( cars.cat_03.badge:0x000000DCr, "R bumper", actcolor, optical, power );
			addPart( cars.cat_03.badge:0x000000DDr, "R taillights", actcolor, optical, power );
			addPart( cars.cat_03.badge:0x000000DFr, "RL window", actcolor, optical, power );
			addPart( cars.cat_03.badge:0x000000E1r, "F windshield", actcolor, optical, power );
			addPart( cars.cat_03.badge:0x000000E2r, "R seats", actcolor, optical, power );
			addPart( cars.cat_03.badge:0x000000E3r, "L taillights", actcolor, optical, power );
			addPart( cars.cat_03.badge:0x000000E5r, "F grill", actcolor, optical, power );
			addPart( cars.cat_03.badge:0x000000E8r, "RR window", actcolor, optical, power );
			addPart( cars.cat_03.badge:0x000000F6r, "F bumper panel", actcolor, optical, power );
			addPart( cars.cat_03.badge:0x000000FAr, "R exhaust pipe", actcolor, optical, power );
			addPart( cars.cat_03.badge:0x000000FBr, "L exhaust pipe", actcolor, optical, power );
			addPart( cars.cat_03.badge:0x000000FCr, "FL seat", actcolor, optical, power );
			addPart( cars.cat_03.badge:0x000000FDr, "FR seat", actcolor, optical, power );
		} else
		{
			if ( optical >= random() ) addPart( cars.cat_03.badge:0x000000D2r, "trunk", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_03.badge:0x000000D3r, "R windshield", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_03.badge:0x000000D9r, "FL door", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_03.badge:0x000000DAr, "FR door", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_03.badge:0x000000DCr, "R bumper", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_03.badge:0x000000DDr, "R taillights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_03.badge:0x000000DFr, "RL window", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_03.badge:0x000000E1r, "F windshield", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_03.badge:0x000000E2r, "R seats", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_03.badge:0x000000E3r, "L taillights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_03.badge:0x000000E5r, "F grill", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_03.badge:0x000000E8r, "RR window", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_03.badge:0x000000F6r, "F bumper panel", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_03.badge:0x000000FAr, "R exhaust pipe", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_03.badge:0x000000FBr, "L exhaust pipe", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_03.badge:0x000000FCr, "FL seat", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_03.badge:0x000000FDr, "FR seat", actcolor, optical, power );
		}

		// parts that have multiple appearance //
		if ( optical <= 1.0 )
		{
			if ( optical >= random() ) addPart( cars.cat_03.badge:0x000000E0r, "F grill frame", actcolor, optical, power );
		} else
		{
			part_random = random();
			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_03.badge:0x000000EAr, "F grill frame 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_03.badge:0x000000E9r, "F grill frame 2", actcolor, optical, power ); else
			addPart( cars.cat_03.badge:0x000000E0r, "F grill frame", actcolor, optical, power );
		}

		addPart( cars.cat_03.badge:0x000000F1r, "FR suspension" );
		addPart( cars.cat_03.badge:0x000000F2r, "FL suspension" );
		addPart( cars.cat_03.badge:0x000000F3r, "RR suspension" );
		addPart( cars.cat_03.badge:0x000000F4r, "RL suspension" );

		if ( optical < 1.0 )
		{
			addPart( parts.wheels_combo:0x000000C1r, "wheel" );
			addPart( parts.wheels_combo:0x000000C1r, "wheel" );
			addPart( parts.wheels_combo:0x000000C1r, "wheel" );
			addPart( parts.wheels_combo:0x000000C1r, "wheel" );

		} else
		{
			if ( (power+optical)*0.5 >= 1.8 ) // 255-19F 375-21R custom wheels //
			{
				if ( random() > 0.5 ) // Chromo //
				{
					addPart( parts.wheels_combo:0x000000AAr, "wheel" );
					addPart( parts.wheels_combo:0x000000AAr, "wheel" );
					addPart( parts.wheels_combo:0x00000BACr, "wheel" );
					addPart( parts.wheels_combo:0x00000BACr, "wheel" );
				} else
				if ( random() > 0.5 ) // Sparkler //
				{
					addPart( parts.wheels_combo:0x000000B6r, "wheel" );
					addPart( parts.wheels_combo:0x000000B6r, "wheel" );
					addPart( parts.wheels_combo:0x00000BB8r, "wheel" );
					addPart( parts.wheels_combo:0x00000BB8r, "wheel" );
				} else               // SI //
				{
					addPart( parts.wheels_combo:0x000000B3r, "wheel" );
					addPart( parts.wheels_combo:0x000000B3r, "wheel" );
					addPart( parts.wheels_combo:0x00000BB5r, "wheel" );
					addPart( parts.wheels_combo:0x00000BB5r, "wheel" );
				}
			} else
			if ( (power+optical)*0.5 >= 1.500 ) // Boss //
			{
				addPart( parts.wheels_combo:0x000001D4r, "wheel" );
				addPart( parts.wheels_combo:0x000001D4r, "wheel" );
				addPart( parts.wheels_combo:0x000001D7r, "wheel" );
				addPart( parts.wheels_combo:0x000001D7r, "wheel" );
			} else                           // Babe //
			{
				addPart( parts.wheels_combo:0x000001D3r, "wheel" );
				addPart( parts.wheels_combo:0x000001D3r, "wheel" );
				addPart( parts.wheels_combo:0x000001D6r, "wheel" );
				addPart( parts.wheels_combo:0x000001D6r, "wheel" );
			}
		}

		if ( power >= 1.4 ) // Bilstein street racer //
		{
			addPart( parts.running_gear:0x000001F6r, "shock" );
			addPart( parts.running_gear:0x000001F6r, "shock" );
			addPart( parts.running_gear:0x000001F7r, "shock" );
			addPart( parts.running_gear:0x000001F7r, "shock" );
		} else
		if ( power >= 1.2 ) // Bilstein aftermarket //
		{
			addPart( parts.running_gear:0x000001EFr, "shock" );
			addPart( parts.running_gear:0x000001EFr, "shock" );
			addPart( parts.running_gear:0x000001F0r, "shock" );
			addPart( parts.running_gear:0x000001F0r, "shock" );
		} else                // stock //
		{
			addPart( parts.running_gear:0x000011FFr, "shock" );
			addPart( parts.running_gear:0x000011FFr, "shock" );
			addPart( parts.running_gear:0x000012FFr, "shock" );
			addPart( parts.running_gear:0x000012FFr, "shock" );
		}

		if ( power >= 1.666 ) // H&R pro racer 42000 Nm 13" //
		{
			addPart( parts.running_gear:0x000001FEr, "spring" );
			addPart( parts.running_gear:0x000001FEr, "spring" );
			addPart( parts.running_gear:0x000001FFr, "spring" );
			addPart( parts.running_gear:0x000001FFr, "spring" );
		} else
		if ( power >= 1.333 ) // H&R street racer 34000 Nm 14" //
		{
			addPart( parts.running_gear:0x00000210r, "spring" );
			addPart( parts.running_gear:0x00000210r, "spring" );
			addPart( parts.running_gear:0x00000211r, "spring" );
			addPart( parts.running_gear:0x00000211r, "spring" );
		} else                // stock 28000Nm 14" //
		{
			addPart( parts.running_gear:0x000013FFr, "spring" );
			addPart( parts.running_gear:0x000013FFr, "spring" );
			addPart( parts.running_gear:0x000014FFr, "spring" );
			addPart( parts.running_gear:0x000014FFr, "spring" );
		}

		if ( power >= 1.588 ) // Baer carbon 12.5"F 13.0"R //
		{
			addPart( parts.running_gear:0x000000E2r, "FL brake" );
			addPart( parts.running_gear:0x000000E5r, "FR brake" );
			addPart( parts.running_gear:0x000000FAr, "RL brake" );
			addPart( parts.running_gear:0x000000FFr, "RR brake" );
		} else
		if ( power >= 1.233 ) // Baer drilled 12.5"F 12.5"R //
		{
			addPart( parts.running_gear:0x00000108r, "FL brake" );
			addPart( parts.running_gear:0x00000132r, "FR brake" );
			addPart( parts.running_gear:0x00000136r, "RL brake" );
			addPart( parts.running_gear:0x00000146r, "RR brake" );
		} else
		{
			addPart( parts.running_gear:0x000021FFr, "FL brake" );
			addPart( parts.running_gear:0x000022FFr, "FR brake" );
			addPart( parts.running_gear:0x000023FFr, "RL brake" );
			addPart( parts.running_gear:0x000024FFr, "RR brake" );
		}

		if ( power >= 1.6 ) // supersport //
		{
			addPart( parts.running_gear:0x00000164r, "F swaybar" );
			addPart( parts.running_gear:0x00000181r, "R swaybar" );
		} else
		if ( power >= 1.3 ) // sport //
		{
			addPart( parts.running_gear:0x00000154r, "F swaybar" );
			addPart( parts.running_gear:0x0000015Cr, "R swaybar" );
		} else              // stock //
		{
			addPart( parts.running_gear:0x000041FFr, "F swaybar" );
			addPart( parts.running_gear:0x000042FFr, "R swaybar" );
		}
		
		int supercharged;
		float enginePow;
		
		if ( power >= 1.8 )
		{
			enginePow = (power-1.8)/0.2*2;
			addPart( parts.engines.V8:0x0000000Cr, "10.0L V8 engine", actcolor, optical, enginePow );
		} else
		if ( power >= 1.6 )
		{
			enginePow = (power-1.6)/0.2*2;
			addPart( parts.engines.V8:0x0000000Br, "8.5L V8 engine", actcolor, optical, enginePow );
		} else
		if ( power >= 1.4 )
		{
			enginePow = (power-1.4)/0.2*2;
			addPart( parts.engines.V8:0x0000000Ar, "6.5L V8 engine", actcolor, optical, enginePow );
		} else
		if ( power >= 1.2 )
		{
			enginePow = (power-1.2)/0.2*2;
			addPart( parts.engines.V8:0x00000009r, "5.7L V8 engine", actcolor, optical, enginePow );
		} else
		if ( power >= 1 )
		{
			enginePow = (power-1)/0.2*2;
			addPart( parts.engines.V8:0x00000008r, "5.0L V8 engine", actcolor, optical, enginePow );
		} else
		if ( power >= 0.833 ) addPart( parts.engines.V6:0x00000008r, "4.0L V6 engine", actcolor, optical, (1-power)/0.166*2 ); else
		if ( power >= 0.666 ) addPart( parts.engines.V6:0x00000007r, "3.3L V6 engine", actcolor, optical, (0.833-power)/0.166*2 ); else
		if ( power >= 0.5 ) addPart( parts.engines.V6:0x00000060r, "2.8L V6 engine", actcolor, optical, (0.666-power)/0.166*2 );
		
		if(enginePow >= 1.50) supercharged++; //EvilMcSheep: Or at least has the sc intake manifold, which brings the intake too high as well
		
		if ( power >= 1.666 ) addPart( parts:0x000000E9r, "silver battery" ); else
		if ( power >= 1.333 ) addPart( parts:0x000000E8r, "blue battery" ); else
		addPart( parts:0x000053FFr, "black battery" );

		if ( optical <= 1.0 )
		{
			if ( optical >= random() && !supercharged ) addPart( cars.cat_03.badge:0x000000D1r, "hood", actcolor, optical, power );
		} else
		{
			if(!supercharged)
			{	//Original for cut: 0.666
				if ( optical-1 >= 0.700 ) addPart( cars.racers.badge:0x000000F5r, "hood 3", actcolor, optical, power ); else //Can still gen with cut hood, use your imagination how that happens :D
				if ( optical-1 >= 0.333 ) addPart( cars.cat_03.badge:0x000000F7r, "hood 2", actcolor, optical, power ); else
				addPart( cars.cat_03.badge:0x000000D1r, "hood", actcolor, optical, power );
			}
			else if ( optical > 1.150 ) addPart( cars.cat_03.badge:0x000000F5r, "hood 3", actcolor, optical, power );
		}
		
		addPart( cars.cat_03.Badge:0x0000FFB4r, "steering wheel" );
	}
	
	public void setDrive(int fwd, int rwd, float drive_front)
	{
		if((fwd && !rwd) || (rwd && !fwd)) super.setDrive(0,1,0.0); //2WD all becomes RWD
		else super.setDrive(fwd, rwd, drive_front); //Leave AWD alone 
	}
}
